<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param><xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="dcfu:CompteFinancierUnique"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"Liberation Serif";
  panose-1:2 2 6 3 5 4 5 2 3 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.Contenudetableau, li.Contenudetableau, div.Contenudetableau
  {
  margin:0cm;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Arial",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR" style="word-wrap:break-word"><div id="header">
         <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><td width="75%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p style="punctuation-wrap:simple"><span style="font-size: 10.0pt;font-family:&#34;Arial&#34;,sans-serif">
                        <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@CodeBC)"/> – 
                        
                        
                        <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Libelle)"/></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right;punctuation-wrap:simple"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice 
                        
                        
                        <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V)"/></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><tr><td width="90%" valign="top" style="border:solid black 1.0pt; border-right:none;padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><xsl:variable name ="Refer1">AARRESIG</xsl:variable><xsl:variable name ="Refer2" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Refer3" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer1, '_', $Refer2, '_', $Refer3)"/></xsl:call-template><b>V – ARRETE ET SIGNATURES</b></p>
               </td><td width="10%" valign="top" style="border:solid black 1.0pt; padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><b>V</b></p>
               </td></tr><tr><td width="90%" valign="top" style="border-top:none;border-left: solid black 1.0pt;border-bottom:solid black 1.0pt;border-right:none; padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><b>ARRETE ET SIGNATURE</b></p>
               </td><td width="10%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><b>A</b></p>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><b> </b></p>
         <p class="MsoNormal"><span style="font-size:8.0pt">Date d'édition : <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Edition/@DateEdition)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p>
         <p class="MsoNormal"> </p>
         <xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><tr><td width="40%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt; height:1.25pt" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt">Comptable(s)</span></b></p>
               </td><td width="5%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt; height:1.25pt" rowspan="1" colspan="1"> </td><td width="55%" colspan="3" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt; height:1.25pt" rowspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt">Ayant exercé au cours de la gestion</span></b></p>
               </td></tr><xsl:for-each select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Gestion/@NomComptable"><xsl:sort>$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Gestion/@DateDebutGestion</xsl:sort><xsl:variable name="codeBoucleBloc_DCPT_ETT_Ge_NomComptable" select="."></xsl:variable><xsl:variable name="blocLignes_DCPT_ETT_Ge_NomComptable" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Gestion[(./@NomComptable=$codeBoucleBloc_DCPT_ETT_Ge_NomComptable)]"/><xsl:if test="$blocLignes_DCPT_ETT_Ge_NomComptable"><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm1" select="$docbudg[(./xad:DocumentComptable/xad:EnteteComptable/xad:Infos/xad:Gestion/@NomComptable=$codeBoucleBloc_DCPT_ETT_Ge_NomComptable)]/xad:DocumentBudgetaire/xad:Budget/xad:LigneBudget"/><xsl:variable name="content1">
                  <span></span>
               </xsl:variable><xsl:variable name="className1">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className1" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">40%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content1" /></xsl:call-template><xsl:variable name="content2"> </xsl:variable><xsl:variable name="className2">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className2" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">5%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content2" /></xsl:call-template><xsl:variable name="content3"> </xsl:variable><xsl:variable name="className3">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className3" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">25%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content3" /></xsl:call-template><xsl:variable name="content4"> </xsl:variable><xsl:variable name="className4">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className4" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">5%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content4" /></xsl:call-template><xsl:variable name="content5"> </xsl:variable><xsl:variable name="className5">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className5" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">25%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content5" /></xsl:call-template></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm2" select="$docbudg/dc:DocumentComptable[(./dc:EnteteComptable/dc:Infos/dc:Gestion/@NomComptable=$codeBoucleBloc_DCPT_ETT_Ge_NomComptable)]/dc:BudgetComptable/dc:LigneComptable"/><td width="40%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p><span style="font-size:8.0pt;color:black"><xsl:value-of select="distinct-values($codeBoucleBloc_DCPT_ETT_Ge_NomComptable)"/></span></p></td><td width="5%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><span style="font-size:8.0pt">du</span></p>
               </td><td width="25%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p><span lang="EN-US" style="font-size:8.0pt;color:black"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DCPT_ETT_Ge_NomComptable/@DateDebutGestion)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td><td width="5%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><span style="font-size:8.0pt">au</span></p>
               </td><td width="25%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p><span style="font-size:8.0pt;color:black"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DCPT_ETT_Ge_NomComptable/@DateFinGestion)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template> <xsl:if test="not($blocLignes_DCPT_ETT_Ge_NomComptable/@DateFinGestion)"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos[(./dc:Gestion/@NomComptable=$codeBoucleBloc_DCPT_ETT_Ge_NomComptable)]/dc:Edition/@DateEdition)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:if></span></p></td></tr></xsl:if></xsl:for-each></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span lang="EN-US" style="font-size:8.0pt"> </span></p>
         <p class="MsoNormal"><span style="font-size:8.0pt">Vu et certifié par le comptable supérieur ou son délégué qui déclare que le présent compte est exact en ses résultats.</span></p>
         <p class="MsoNormal"><span style="font-size:8.0pt"> </span></p>
         <xsl:variable name="varOdmTmpTab4"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm3" select="$docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(not(./xad:SigningMode))]/xad:SignerRole/xad:ClaimedRoles[(./xad:ClaimedRole='Comptable supérieur')]/xad:ClaimedRole"/><tr><td width="64%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p><span style="font-size:8.0pt"> <span style="color:black"> <u>Observations</u> : <xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable supérieur') and (not(./xad:SigningMode))]/xad:SigningComment)"/></span></span></p></td><td width="36%" valign="top" style="padding:0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"> </td></tr><tr><td width="64%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p><span style="font-size:8.0pt;color:black"><xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable supérieur') and (not(./xad:SigningMode))]/xad:SignerIdentity/xad:SignerName)"/></span></p></td><td width="36%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="font-size:8.0pt;color:black">A <xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable supérieur') and (not(./xad:SigningMode))]/xad:SignatureProductionPlace/xad:City)"/>, le  </span><span style="font-size:8.0pt;color:black"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable supérieur') and (not(./xad:SigningMode))]/xad:SigningTime)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab4"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:8.0pt"> </span></p>
         <p class="MsoNormal"><span style="font-size:8.0pt">Le comptable soussigné affirme véritable, sous les peines de droit, le présent compte.</span></p>
         <xsl:variable name="varOdmTmpTab5"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm4" select="$docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(not(./xad:SigningMode))]/xad:SignerRole/xad:ClaimedRoles[(./xad:ClaimedRole='Comptable assignataire')]/xad:ClaimedRole"/><tr><td width="64%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p><span style="font-size:8.0pt"> <span style="color:black"><xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable assignataire') and (not(./xad:SigningMode))]/xad:SignerIdentity/xad:SignerName)"/></span></span></p></td><td width="36%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="font-size:8.0pt;color:black">A <xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable assignataire') and (not(./xad:SigningMode))]/xad:SignatureProductionPlace/xad:City)"/>, le  </span><span style="font-size:8.0pt;color:black"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable assignataire') and (not(./xad:SigningMode))]/xad:SigningTime)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab5"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:8.0pt"> </span></p>
         <xsl:variable name="varOdmTmpTab6"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm5" select="$docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(not(./xad:SigningMode))]/xad:SignerRole/xad:ClaimedRoles[(./xad:ClaimedRole='Ordonnateur')]/xad:ClaimedRole"/><tr><td width="100%" colspan="2" valign="top" style=" padding: 0cm 5.4pt 1.5pt 0cm;" rowspan="1"><p><span style="font-size:8.0pt"> <span style="color:black">Vu par l’ordonnateur ou son délégué qui certifie que le présent compte a été voté le <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Ordonnateur') and (not(./xad:SigningMode))]/xad:SigningDateVote)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template> par l’organe délibérant.</span></span></p></td></tr><tr><td width="64%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p><span style="font-size:8.0pt;color:black"><xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Ordonnateur') and (not(./xad:SigningMode))]/xad:SignerIdentity/xad:SignerName)"/></span></p></td><td width="36%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="font-size:8.0pt;color:black">A <xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Ordonnateur') and (not(./xad:SigningMode))]/xad:SignatureProductionPlace/xad:City)"/>, le </span><span style="font-size:8.0pt;color:black"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Ordonnateur') and (not(./xad:SigningMode))]/xad:SigningTime)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab6"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:8.0pt"> </span></p>
         <xsl:variable name="varOdmTmpTab7"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm6" select="$docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SigningMode='F')]/xad:SigningMode"/><xsl:choose><xsl:when test="$docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties/xad:SigningMode = 'F'"><xsl:variable name="varOdm7" select="$varOdm6"/><tr><td width="100%" colspan="2" valign="top" style=" padding: 0cm 5.4pt 1.5pt 0cm;" rowspan="1"><p><span style="font-size:8.0pt"><b><span style="color:black">Le comptable supérieur a forcé la validation du présent compte en l’absence de validation par l’ordonnateur.</span></b></span></p><p><u><span style="font-size:8.0pt;color:black">Observations</span></u><span style="font-size:8.0pt;color:black">: <xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SigningMode='F')]/xad:SigningComment)"/></span></p></td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" colspan="2" valign="top" rowspan="1" style=" padding: 0cm 5.4pt 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties/xad:SigningMode = 'F'"><xsl:variable name="varOdm8" select="$varOdm6"/><tr><td width="64%" valign="top" style="padding: 0cm 5.4pt 1.5pt 0cm;" rowspan="1" colspan="1">
                  <p class="MsoNormal"><b><span style="font-size:8.0pt"></span></b></p>
               </td><td width="36%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="font-size:8.0pt;color:black">A <xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SigningMode='F')]/xad:SignatureProductionPlace/xad:City)"/>, le  </span><span style="font-size:8.0pt;color:black"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SigningMode='F')]/xad:SigningTime)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" colspan="2" valign="top" rowspan="1" style=" padding: 0cm 5.4pt 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab7"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:8.0pt"> </span></p>
         <xsl:variable name="varOdmTmpTab8"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm9" select="$docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties/xad:SignerRole/xad:ClaimedRoles[(./xad:ClaimedRole='Comptable assignataire')]/xad:ClaimedRole"/><xsl:choose><xsl:when test="$docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties/xad:SigningMode = 'A'"><xsl:variable name="varOdm10" select="$varOdm9"/><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 0cm;" rowspan="1">
                  <p class="MsoNormal"><span style="font-size:8.0pt"><b>Le comptable supérieur ayant signifié que le budget est inactif, l’ordonnateur est dispensé de validation du présent
                           compte. Il est ainsi validé automatiquement par l’application, concomitamment à la validation du comptable assignataire.</b></span></p>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" colspan="2" valign="top" rowspan="1" style="padding: 0cm 5.4pt 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties/xad:SigningMode = 'A'"><xsl:variable name="varOdm11" select="$varOdm9"/><tr><td width="64%" valign="top" style="padding: 0cm 5.4pt 1.5pt 0cm;" rowspan="1" colspan="1">
                  <p class="MsoNormal"><b><span style="font-size:8.0pt"></span></b></p>
               </td><td width="36%" valign="top" style="padding: 0cm 5.4pt 1.5pt 0cm;" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="font-size:8.0pt;color:black">A <xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable assignataire')]/xad:SignatureProductionPlace/xad:City)"/>, le  </span><span style="font-size:8.0pt;color:black"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable assignataire')]/xad:SigningTime)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" colspan="2" valign="top" rowspan="1" style="padding: 0cm 5.4pt 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab8"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt"> </span></p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>